# Copyright 2022 Garena Online Private Limited.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
import absl.app

from experiments.args import FLAGS_DEF
from experiments.mf_trainer import MFTrainer


def main(argv):
  model_type = absl.flags.FLAGS.type

  if model_type == "model-free":
    mf_trainer = MFTrainer(FLAGS_DEF)
    mf_trainer.train()
  else:
    raise NotImplementedError


if __name__ == '__main__':
  absl.app.run(main)
